/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.reality;

import dev.xkmc.curseofpandora.content.complex.AttrAdder;
import dev.xkmc.curseofpandora.content.complex.IAttackListenerToken;
import dev.xkmc.curseofpandora.content.complex.ISlotAdderItem;
import dev.xkmc.curseofpandora.content.complex.ListTickingToken;
import dev.xkmc.curseofpandora.content.complex.SlotAdder;
import dev.xkmc.curseofpandora.content.reality.CursePandoraUtil;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPEffects;
import dev.xkmc.l2complements.mixin.LevelAccessor;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2library.base.effects.ClientEffectCap;
import dev.xkmc.l2library.capability.conditionals.NetworkSensitiveToken;
import dev.xkmc.l2library.capability.conditionals.TokenKey;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import org.jetbrains.annotations.Nullable;

public class CurseOfTensionItem
extends ISlotAdderItem<Ticker> {
    private static final SlotAdder ADDER = SlotAdder.of("curse_of_tension", CoPConfig.COMMON.curse.curseOfTensionSlot);
    public static final TokenKey<Ticker> KEY = new TokenKey("curseofpandora", "curse_of_tension");
    private static final AttrAdder R = CursePandoraUtil.reality(KEY);
    private static final AttrAdder S = CursePandoraUtil.spell(KEY);

    public static int getPenaltyDuration() {
        return (Integer)CoPConfig.COMMON.curse.curseOfTensionPenaltyDuration.get();
    }

    public static double getDamageThreshold() {
        return (Double)CoPConfig.COMMON.curse.curseOfTensionPenaltyThreshold.get();
    }

    public static int getTokenMature() {
        return (Integer)CoPConfig.COMMON.curse.curseOfTensionTokenMatureTime.get();
    }

    public static int getTokenLife() {
        return (Integer)CoPConfig.COMMON.curse.curseOfTensionTokenEffectiveTime.get();
    }

    public static float getDamageBonus() {
        return (float)((Double)CoPConfig.COMMON.curse.curseOfTensionDamageBonus.get()).doubleValue();
    }

    public static int getMaxLevel() {
        return (Integer)CoPConfig.COMMON.curse.curseOfTensionMaxLevel.get();
    }

    public CurseOfTensionItem(Item.Properties properties) {
        super(properties, Ticker::new, ADDER, R, S);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        int tkMat = CurseOfTensionItem.getTokenMature();
        int tkLife = CurseOfTensionItem.getTokenLife();
        int dur = CurseOfTensionItem.getPenaltyDuration();
        int max = CurseOfTensionItem.getMaxLevel();
        int damage = Math.round(CurseOfTensionItem.getDamageBonus() * 100.0f);
        int th = (int)Math.round(CurseOfTensionItem.getDamageThreshold() * 100.0);
        list.add((Component)CoPLangData.Reality.TENSION_1.get(tkMat / 20, damage, tkLife / 20, max).m_130940_(ChatFormatting.GRAY));
        list.add((Component)CoPLangData.Reality.TENSION_2.get(th, dur / 20).m_130940_(ChatFormatting.RED));
    }

    @SerialClass
    public static class Ticker
    extends ListTickingToken
    implements IAttackListenerToken,
    NetworkSensitiveToken<Ticker> {
        @SerialClass.SerialField
        public HashMap<UUID, Long> terror = new HashMap();
        @SerialClass.SerialField
        public HashMap<UUID, ArrayList<Long>> brave = new HashMap();
        private boolean sync = false;

        public Ticker() {
            super(List.of(ADDER, R, S));
        }

        @Override
        protected void removeImpl(Player player) {
            super.removeImpl(player);
            this.terror.clear();
            this.removeEffect(player);
        }

        @Override
        protected void tickImpl(Player player) {
            super.tickImpl(player);
            Level level = player.m_9236_();
            this.sync = false;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                ServerLevel sl = sp.m_284548_();
                this.sync = this.terror.entrySet().removeIf(e -> {
                    LivingEntity le;
                    Entity patt3864$temp = sl.m_8791_((UUID)e.getKey());
                    return !(patt3864$temp instanceof LivingEntity) || !(le = (LivingEntity)patt3864$temp).m_6084_() || level.m_46467_() > (Long)e.getValue() + (long)CurseOfTensionItem.getPenaltyDuration();
                });
                this.sync |= this.brave.entrySet().removeIf(ent -> {
                    LivingEntity le;
                    Entity patt4064$temp = sl.m_8791_((UUID)ent.getKey());
                    if (!(patt4064$temp instanceof LivingEntity) || !(le = (LivingEntity)patt4064$temp).m_6084_()) {
                        return true;
                    }
                    this.sync |= ((ArrayList)ent.getValue()).removeIf(t -> level.m_46467_() > t + (long)CurseOfTensionItem.getTokenLife() + (long)CurseOfTensionItem.getTokenMature());
                    return ((ArrayList)ent.getValue()).isEmpty();
                });
                if (this.sync) {
                    this.sync(sp);
                }
            } else {
                this.checkEffect(player);
            }
        }

        @Override
        public void onPlayerDamagedFinal(Player player, AttackCache cache) {
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)player;
            LivingEntity attacker = cache.getAttacker();
            if (attacker == null) {
                return;
            }
            if (attacker == player) {
                return;
            }
            if ((double)cache.getDamageDealt() >= (double)player.m_21233_() * CurseOfTensionItem.getDamageThreshold()) {
                this.terror.put(attacker.m_20148_(), player.m_9236_().m_46467_());
            }
            this.brave.remove(attacker.m_20148_());
            this.sync(sp);
        }

        public boolean isTerrorized(LivingEntity target) {
            return this.terror.containsKey(target.m_20148_());
        }

        @Override
        public void onPlayerAttackTarget(Player player, AttackCache cache) {
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            if (this.isTerrorized(cache.getAttackTarget())) {
                LivingAttackEvent event = cache.getLivingAttackEvent();
                assert (event != null);
                event.setCanceled(true);
            }
        }

        @Override
        public void onPlayerHurtTarget(Player player, AttackCache cache) {
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)player;
            long time = player.m_9236_().m_46467_();
            LivingEntity target = cache.getAttackTarget();
            if (player == target) {
                return;
            }
            List list = this.brave.get(target.m_20148_());
            int count = 0;
            if (list != null) {
                for (Long e : list) {
                    if (time <= e + (long)CurseOfTensionItem.getTokenMature()) continue;
                    ++count;
                }
            }
            if (count > 0) {
                count = Math.min(count, CurseOfTensionItem.getMaxLevel());
                cache.addHurtModifier(DamageModifier.multTotal((float)(1.0f + (float)count * CurseOfTensionItem.getDamageBonus())));
            }
            this.brave.computeIfAbsent(target.m_20148_(), k -> new ArrayList()).add(time);
            this.sync(sp);
        }

        private void sync(ServerPlayer sp) {
            this.sync(KEY, this, sp);
        }

        public void onSync(@Nullable Ticker old, Player player) {
            if (old != null) {
                old.removeEffect(player);
            }
            this.checkEffect(player);
        }

        private void removeEffect(Player player) {
            ClientEffectCap cap;
            LivingEntity le;
            Entity ent;
            if (!player.m_9236_().m_5776_()) {
                return;
            }
            for (UUID id : this.terror.keySet()) {
                ent = (Entity)((LevelAccessor)player.m_9236_()).callGetEntities().m_142694_(id);
                if (!(ent instanceof LivingEntity)) continue;
                le = (LivingEntity)ent;
                cap = (ClientEffectCap)ClientEffectCap.HOLDER.get((ICapabilityProvider)le);
                cap.map.remove(CoPEffects.FAKE_TERRORIZED.get());
            }
            for (UUID id : this.brave.keySet()) {
                ent = (Entity)((LevelAccessor)player.m_9236_()).callGetEntities().m_142694_(id);
                if (!(ent instanceof LivingEntity)) continue;
                le = (LivingEntity)ent;
                cap = (ClientEffectCap)ClientEffectCap.HOLDER.get((ICapabilityProvider)le);
                cap.map.remove(CoPEffects.FAKE_TERROR_PRE.get());
                cap.map.remove(CoPEffects.FAKE_TERROR.get());
            }
        }

        private void checkEffect(Player player) {
            ClientEffectCap cap;
            LivingEntity le;
            Entity ent;
            if (!player.m_9236_().m_5776_()) {
                return;
            }
            long time = player.m_9236_().m_46467_();
            for (Map.Entry<UUID, ArrayList<Long>> entry : this.brave.entrySet()) {
                ent = (Entity)((LevelAccessor)player.m_9236_()).callGetEntities().m_142694_(entry.getKey());
                if (!(ent instanceof LivingEntity)) continue;
                le = (LivingEntity)ent;
                cap = (ClientEffectCap)ClientEffectCap.HOLDER.get((ICapabilityProvider)le);
                cap.map.remove(CoPEffects.FAKE_TERROR_PRE.get());
                cap.map.remove(CoPEffects.FAKE_TERROR.get());
                int pre = 0;
                int lost = 0;
                for (long t : entry.getValue()) {
                    if (time > t + (long)CurseOfTensionItem.getTokenMature()) {
                        ++lost;
                        continue;
                    }
                    ++pre;
                }
                if (pre > 0) {
                    cap.map.put((MobEffect)CoPEffects.FAKE_TERROR_PRE.get(), pre - 1);
                }
                if (lost <= 0) continue;
                cap.map.put((MobEffect)CoPEffects.FAKE_TERROR.get(), lost - 1);
            }
            for (Map.Entry<UUID, Serializable> entry : this.terror.entrySet()) {
                ent = (Entity)((LevelAccessor)player.m_9236_()).callGetEntities().m_142694_(entry.getKey());
                if (!(ent instanceof LivingEntity)) continue;
                le = (LivingEntity)ent;
                cap = (ClientEffectCap)ClientEffectCap.HOLDER.get((ICapabilityProvider)le);
                cap.map.put((MobEffect)CoPEffects.FAKE_TERRORIZED.get(), 0);
            }
        }
    }
}

